/*
 * telnetFlags.h - flags that can be set on initial startup of a telnet client.
 *	- Chris Gray, cg@ami-cg.GraySage.Edmonton.AB.CA, Nov 1998.
 */

#define B_NEG_BINARY	0x0001	/* negotiate BINARY */
#define B_NEG_ECHO	0x0002	/* negotiate initial server ECHO */
#define B_NEG_PSEUDO	0x0004	/* negotiate pseudo-line-mode */
#define B_NEG_SUPGA 	0x0008	/* negotiate SUPpress GoAhead */
#define B_NEG_EORMODE	0x0010	/* negotiate send of EOR */
#define B_NEG_TTYTYPE	0x0020	/* negotiate use of TTYTYPE */
#define B_NEG_NAWS	0x0040	/* "" NAWS (Negotiate About Window Size */
#define B_INIT_ECHO 	0x0080	/* initial value of server's "I echo" flag */
#define B_INIT_EORMODE	0x0100	/* initial value of server's doEOR flag */
#define B_SEND_GA	0x0200	/* initial value of sending GA flag */
#define B_PW_BLANK	0x0400	/* should server try to blank passwords? */
#define B_PW_BLANK_SUPGA 0x0800	/* should server use SUPGA in blanking? */
#define B_ERASE_PROMPT	0x1000	/* should server try to erase prompts? */

/* Default is for a decent normal telnet client. (type 't') */

#define DEFAULT_TELNET_FLAGS \
    (B_NEG_BINARY | B_NEG_PSEUDO | B_NEG_SUPGA | \
     B_NEG_EORMODE | B_NEG_TTYTYPE | B_NEG_NAWS | \
     B_ERASE_PROMPT | B_PW_BLANK | B_PW_BLANK_SUPGA)

/* Flags for a client that doesn't understand telnet at all. (type 's') */

#define SIMPLE_TELNET_FLAGS	0x0

/* Flags for a client that normally works with LPMUD. (type 'l') */

#define LPMUD_TELNET_FLAGS \
    (B_NEG_BINARY | B_NEG_TTYTYPE | B_NEG_NAWS | B_SEND_GA | B_PW_BLANK)
