struct Client;

typedef enum {
    t_void,
    t_int,
    t_string,
    t_proc,
    t_thing,
    t_variable
} Type_t;

typedef struct {
    union {
	int v_int;
	char *v_string;
	char *v_proc;
	struct thing *v_thing;
	struct variable *v_variable;
    } v_;
    Type_t v_type;
} Value_t;

typedef struct variable {
    struct variable *v_next;
    char *v_name;
    Value_t v_value;
} Variable_t;

typedef struct thing {
    struct thing *th_next;
    char *th_name;
    Variable_t *th_context;
    bool_t th_written;
} Thing_t;

typedef struct player {
    struct player *pl_next;
    struct player *pl_prev;
    char *pl_password;
    Thing_t pl_thing;
    Thing_t *pl_location;
} Player_t;

extern void mudAbort(char *message);
extern void *mudAlloc(unsigned int len);
extern void mudFree(void *p);
extern char *mudStrDup(const char *s);
extern void va_cprintf(struct Client *cl, const char *fmt, va_list ap);
extern void cprintf(struct Client *cl, const char *fmt, ...);
extern void aprintf(struct Client *cl, const char *fmt, ...);
extern char *getWord(void);
extern char *getTail(void);
extern void setTail(char *st);
extern struct Client *findClient(Thing_t *who);
extern Thing_t *findActivePlayer(char *name, Thing_t *where);
extern int forEachPlayer(char *proc);
extern Thing_t *clientLocation(Thing_t *who);
extern void setClientLocation(Thing_t *who, Thing_t *location);
extern void setQuit(struct Client *cl);
extern Thing_t *createMachine(char *name);
extern bool_t destroyMachine(Thing_t *th);
extern void doAfter(struct Client *cl, int delay, char *proc);
extern bool_t doForce(Thing_t *who, char *proc);
extern void initMachine(Player_t *pl);

extern Thing_t *findThing(char *name);
extern Thing_t *newThing(char *name);
extern bool_t destroyThing(Thing_t *th);
extern Player_t *newPlayer(char *name);
extern void deletePlayer(Player_t *pl);
extern Player_t *findPlayer(char *name);
extern Player_t *newMachine(char *name);
extern void deleteMachine(Player_t *pl);
extern Variable_t *readDB(char *path);
extern void writeDB(char *path, Variable_t *globals);

extern void initInterpreter(Variable_t *globals);
extern Variable_t *getGlobals(void);
extern void runProc(struct Client *who, Player_t *pl, char *proc);
extern void runWithPlayer(struct Client *who, Player_t *pl, char *name);
extern void runWithString(struct Client *who, Player_t *pl,
			  char *string, char *name);
extern void runExplicitWithPlayer(struct Client *who, Player_t *pl,char *proc);
