/*
 * main.c - simple driver program for net.c and telnet.c
 *	- Chris Gray, cg@ami-cg.GraySage.Edmonton.AB.CA, Nov/Dec 1998.
 */

/*
 * This code is provided as-is. No warranty of any kind is given.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "types.h"
#include "telnetFlags.h"
#include "netClient.h"

#define TELNET_PORT	6666
#define SIMPLE_PORT	6668
#define LPMUD_PORT	6669

/* These are the entries in net.c that we call */
extern bool_t netInit(void);
extern void netAddClientType(const void *netClient, unsigned short int port,
			     int auxData);
extern void netPutText(const struct GenericClient *genericClient,
		       Request_t *rq);
extern void netFlush(const struct GenericClient *genericClient);
extern void netStart(void);
extern void netTerm(void);

/* This is the entry in telnet.c that we call */
extern const void *telnetInit(LineHandler_t lineHandler);

/*
 * lineHandler - we give this to the telnet code as the routine to
 *	handle input lines received. We really ought to give it to the
 *	net code, since it is supposed to be generic.
 */

static void
lineHandler(const struct GenericClient *client,
	    char *buffer, unsigned int len)
{
    char localBuffer[1000];
    Request_t *rq;

    strcpy(&localBuffer[0], "==> ");
    memcpy(&localBuffer[4], buffer, len);
    len += 4;
    localBuffer[len] = '\n';
    len += 1;
    localBuffer[len] = '\0';

    /* Comment this next line out if you don't want all received lines
       echoed to stdout. */
    printf("%s", &localBuffer[0]);

    /* Send the input line, with the "==> " prepended, back to the user. */
    rq = malloc(sizeof(Request_t) - 2 + len);
    rq->rq_next = NULL;
    rq->rq_id = 0;
    rq->rq_availLen = len;
    rq->rq_usedLen = len;
    memcpy(&rq->rq_u.ru_text[0], &localBuffer[0], len);
    netPutText(client, rq);
    netFlush(client);
}

int
main(int argc, char **argv)
{
    const void *netClient;

    if (! netInit()) {
	fprintf(stderr, "netInit failed\n");
	return 1;
    }
    netClient = telnetInit(lineHandler);
    netAddClientType(netClient, TELNET_PORT, DEFAULT_TELNET_FLAGS);
    netAddClientType(netClient, SIMPLE_PORT, SIMPLE_TELNET_FLAGS);
    netAddClientType(netClient, LPMUD_PORT, LPMUD_TELNET_FLAGS);
    netStart();
    netTerm();
    return 0;
}
