#include <stdio.h>
#include <dlfcn.h>

void *extract_function(void *handle, char *name)
{
	int (*setup)(void);
	const char *error;

	setup = dlsym(handle, name);
	if ((error = dlerror()) != NULL)  {
		dlclose(handle);
		handle = (void *)NULL;
		fprintf(stderr, "%s\n", error);
		exit(1);
	}
	return(setup);
}

/* a NULL return indicates (XXX will indicate) failure to load */
void *load_module(char *name)
{
	void *handle;

	handle = dlopen (name, RTLD_LAZY);
	if (!handle) {
		/* XXX this isn't the right error handling */
		fprintf(stderr, "%s\n", dlerror());
		exit(1);
	}
	return(handle);
}

int main(int argc, char **argv)
{
	void *config_handle;
	int (*setup)(void);

	/* XXX we should deal with failure on this */
	config_handle = load_module("./config.so");
	setup = extract_function(config_handle, "setup");
	(*setup)();

	dlclose(config_handle);
	exit(0);
}
