#include <stdio.h>
#include <dlfcn.h>
#include "../bootstrap/bootstrap.h"

int setup(void)
{
	void *socket_handle, *world_handle;
	int (*setup)(void);
	void (*set_function)(char *name, void (*func)());
	void *(*get_function)(char *name);

	socket_handle = load_module("./socket.so");
	world_handle = load_module("./world.so");

	setup = extract_function(socket_handle,"setup");
	(*setup)();

	/* make them talk */
	get_function = extract_function(socket_handle,"get_function");
	set_function = extract_function(world_handle,"set_function");

	(*set_function)("close_connection",
		(*get_function)("close_connection"));
	(*set_function)("parsed_put_string",
		(*get_function)("parsed_put_string"));
	(*set_function)("get_message",
		(*get_function)("get_message"));
	(*set_function)("real_connection",
		(*get_function)("real_connection"));
	(*set_function)("connection_name",
		(*get_function)("connection_name"));

	setup = extract_function(world_handle,"setup");
	(*setup)();

	return(0);
}
