#include <stdio.h>
#include <string.h>

/* XXX static number of players is very bad to assume */
#define MAX_PLAYERS 50

void (*close_connection)(int which);
void (*parsed_put_string)(int to, char *message);
int (*get_message)(char *buffer, int size, int sec, int usec);
int (*real_connection)(int which);
char *(*connection_name)(int which);

void say(char *str)
{
	int loop;

	for (loop=0;loop<MAX_PLAYERS;loop++)
	{
		if (real_connection(loop))
		{
			parsed_put_string(loop,str);
		}
	}
}

void parse_input(int which, char *buffer)
{
	char output_buffer[160];

	if (strncmp(buffer,"say ",4) == 0)
	{
		sprintf(output_buffer,"Player %d says: %s", which, buffer+4);
		say(output_buffer);
	}
	else if (strncmp(buffer,"quit",4) == 0)
	{
		sprintf(output_buffer,"Player %d quit.\n",which);
		say(output_buffer);
		close_connection(which);
	}
	else /* unrecognized command case */
	{
		parsed_put_string(which, "What?\n");
	}
}

void new_player(int which)
{
	char output_buffer[160];

	sprintf(output_buffer,"Player %d", which);
	sprintf(output_buffer,"Welcome, %d! (%s)\n", which, connection_name(which));
	say(output_buffer);
}

void end_player(int which)
{
	char output_buffer[160];

	sprintf(output_buffer,"Bye, %d!\n",which);
	say(output_buffer);
}

int setup(void)
{
	char read_buffer[80];
	int which;

	while(1)
	{
		read_buffer[0] = 0;
		while ((which = get_message(read_buffer,80,1,0)) == -1)
			;
		if (*read_buffer)
		{
			parse_input(which, read_buffer);
		} else {
			if (real_connection(which))
				new_player(which);
			else
				end_player(which);
		}
	}
	return(0);
}

void set_function(char *name, void *func)
{
        if (!strcmp(name,"close_connection"))
                close_connection = func;
        else if (!strcmp(name,"parsed_put_string"))
                parsed_put_string = func;
        else if (!strcmp(name,"get_message"))
                get_message = func;
        else if (!strcmp(name,"real_connection"))
                real_connection = func;
        else if (!strcmp(name,"connection_name"))
                connection_name = func;
}
