struct interface {
	char *name;		/* what the function is called */
	void *function;		/* a function pointer */
	char *prototype;	/* arguments to the function */
	char *description;	/* human-readable text */
};

struct module_handle {
	int flags;	/* static link vs. dynamic, etc. */
	char *name;	/* should be malloc()ed */
	void *dl_handle;
	struct interface *supplies;
	struct interface *uses;
	void (*use_functions)(struct interface *it);
	int (*initialize)(void);
	int (*start)(void);
	int (*stop)(void);
};

void *extract_function(struct module_handle *handle, char *name);
struct module_handle *load_module(char *name);
extern int main_argc;
extern char **main_argv;
