#include <stdio.h>

int main(int argc, char **argv)
{
	int i;

	/* print out file header */
	printf("#include <stdio.h>\n");
	printf("#include \"../include/devmud.h\"\n\n");
	/* output info structures */
	for (i=1; i<argc; i++)
	{
		printf("extern struct interface %s_supplies[];\n",argv[i]);
		printf("extern struct interface %s_uses[];\n",argv[i]);
		printf("extern void %s_use_functions(struct interface *it);;\n",argv[i]);
		printf("extern int %s_initialize(void);\n",argv[i]);
		printf("extern int %s_start(void);\n",argv[i]);
		printf("extern int %s_stop(void);\n",argv[i]);
		printf("\n");
		printf("struct module_handle %s_info = {\n",argv[i]);
		printf("\t1, /* 1 for staticly linked */\n");
		printf("\t\"%s\", /* static names not malloc()ed */\n",argv[i]);
		printf("\tNULL, /* no dl_handle */\n");
		printf("\t%s_supplies,\n",argv[i]);
		printf("\t%s_uses,\n",argv[i]);
		printf("\t%s_use_functions,\n",argv[i]);
		printf("\t%s_initialize,\n",argv[i]);
		printf("\t%s_start,\n",argv[i]);
		printf("\t%s_stop\n",argv[i]);
		printf("};\n\n");
	}

	/* and a main structure */
	printf("struct module_handle *static_modules[] = {\n");
	for (i=1; i<argc; i++)
	{
		printf("\t&%s_info,\n",argv[i]);
	}
	printf("\t(struct module_handle*)NULL\n");
	printf("};\n");

	exit(0);
}
