/* Example DevMUD memory manager module. 
 * Originally written 4/11/99, by Mark Gritter <mgritter@cs.stanford.edu>
 *
 * This follows v0.2 of the DevMUD spec.
 *
 * This alternate implementation of the memory manager module does no
 * statistics gathering.
 */

#include "../include/devmud.h"
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

/* Now the publicly visible functions. */
static void *memory_allocate(const char *module, unsigned int size) {
  return malloc(size);
}

static void memory_free(const char *module, void *location) {
  free(location);
}

static void memory_statistics(const char *module, unsigned int *blocks, unsigned int *bytes) {
  *blocks = 0;
  *bytes = 0;
}

struct interface stub_mm_supplies[] = {
  { "memory_allocate", memory_allocate, 
    "void*(const char*,unsigned int)", NULL },
  { "memory_free", memory_free, 
    "void(const char*,void *)", NULL },
  { "memory_statistics", memory_statistics, 
    "void(const char*,unsigned int*,unsigned int*)", NULL },
  { NULL, NULL, NULL, NULL }
};

struct interface stub_mm_uses[] = {
  { NULL, NULL, NULL, NULL }
};

int stub_mm_initialize(void) {
  return 0;
}

int stub_mm_start(void) {
  return 0;
}

int stub_mm_stop(void) {
  return -1;
}

void stub_mm_use_functions(struct interface *funcs) {
}
