/*
 * prototypes (and structure definitions) for assoc.c
 */

#define STRING 1
#define NUMBER 2

struct data {
	int	type;
	union {
		int id;
		char *text;
		struct hash *h;
	} u;
};

extern void cleanup_data(struct data *it);

struct bucket {
	unsigned int hashvalue;	/* for approx ID check and resize */
	int keytype;
	union {
		int val;
		char *text;	/* malloc'd for exact ID check */
	} key;
	struct data val;
	struct bucket *next;
};

struct hash {
	struct bucket **all_buckets;
	int num_buckets, count, collisions;
};

int init_assoc(struct hash *h, int buckets);
void cleanup_assoc(struct hash *h);
struct bucket *new_string_bucket(struct hash *h, char *key);
struct bucket *new_number_bucket(struct hash *h, int key);
struct bucket *find_string_bucket(struct hash *h, char *key);
struct bucket *find_number_bucket(struct hash *h, int key);
int delete_string_bucket(struct hash *h, char *key);
int delete_number_bucket(struct hash *h, int key);
int resize_assoc(struct hash *h, int buckets);
