#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include "../../include/devmud.h"

/* TODO:  We should really have some way of specifying the last module */

#define MODULE_COUNT 8

extern struct module_handle *static_modules[];

static struct module_handle **dl_handles;
static int num_dl_handles, max_dl_handles;

struct interface config_supplies[] = {
	{NULL,NULL,NULL,NULL}
};

struct interface config_uses[] = {
	{NULL,NULL,NULL,NULL}
};

void config_use_functions(struct interface *it)
{
	return;
}

int config_initialize(void)
{
	return(0);
}

void remember_handle(struct module_handle *it)
{
	struct module_handle **temp;

	if (num_dl_handles == max_dl_handles)
	{
		/* time to malloc more storage */
		max_dl_handles *= 2;
		temp = (struct module_handle **)realloc(dl_handles,
				max_dl_handles*sizeof(struct module_handle *));
		if (temp == (struct module_handle **)NULL)
		{
			/* TODO: handle malloc failure better */
			fprintf(stderr,"Malloc failed.\n");
			exit(-1);
		}
		dl_handles = temp;
	}
	dl_handles[num_dl_handles++] = it;
}

int config_start(void)
{
	struct module_handle *current_handle, *temp_handle;
	struct interface *temp;
	static void (*config_port)(int port) = NULL;
	static void (*config_opt)(char *opt, char *val) = NULL;
	int portnum = 0;
	int i, j;
	char *argcopy, *modname, *option, *value;

	dl_handles = (struct module_handle **)malloc(MODULE_COUNT*
						sizeof(struct module_handle *));
	max_dl_handles = MODULE_COUNT;
	num_dl_handles = 0;

	for (i=1; i<main_argc; i++)
	{
		if (isalpha(main_argv[i][0]) &&	/* maybe module name */
		    (strchr(main_argv[i],'=') == NULL) &&
		    (strcmp(main_argv[i],"config")))
		{
			temp_handle = load_module(main_argv[i]);
			if (temp_handle == (struct module_handle *)NULL)
			{
				fprintf(stderr,"Couldn't load %s.\n",
					main_argv[i]);
			} else {
				remember_handle(temp_handle);
			}
		}
		else if (isdigit(main_argv[i][0]))
		{
			portnum = atoi(main_argv[i]);
		}
	}
	for (i=0; static_modules[i] != (struct module_handle *)NULL; i++)
	{
		if (strcmp(static_modules[i]->name,"config"))
		{
			temp_handle = load_module(static_modules[i]->name);
			if (temp_handle == (struct module_handle *)NULL)
			{
				fprintf(stderr,"Couldn't load %s.\n",
					current_handle->name);
			} else {
				remember_handle(temp_handle);
			}
		}
	}
	for (i=0; i<num_dl_handles; i++)
	{
		if ((*dl_handles[i]->initialize)() != 0)
		{
			fprintf(stderr,"%s failed to initialize.\n",
				dl_handles[i]->name);
			exit(1);
		}
		for (j=0; j<i; j++)
		{
			dl_handles[j]->use_functions(dl_handles[i]->supplies);
			dl_handles[i]->use_functions(dl_handles[j]->supplies);
		}
	}
	if (portnum != 0)
	{
		for (i = 0; i<num_dl_handles; i++)
		{
			temp = dl_handles[i]->supplies;
			while (temp->name != NULL)
			{
				if (!strcmp(temp->name,"config_port"))
				{
					config_port = temp->function;
				}
				temp++;
			}
		}
		if (config_port == NULL)
		{
			fprintf(stderr,
				"Can't get config_port!\n");
			exit(-1);
		}
		(*config_port)(portnum);
	}
	for (i=1; i<main_argc; i++)
	{
		argcopy = strdup(main_argv[i]);
		if (argcopy == NULL)
		{
			fprintf(stderr,"Malloc failed.\n");
			exit(-1);
		}
		if ((value = strchr(argcopy,'=')) != NULL)
		{
			*value++ = 0;
			if ((option = strchr(argcopy,':')) != NULL)
			{
				*option++ = 0;
				modname = argcopy;
			} else {
				option = argcopy;
				modname = NULL;
			}
			for (j = 0; j<num_dl_handles; j++)
			{
				if ((modname == NULL) ||
				    !strcmp(dl_handles[j]->name,modname))
				{
					temp = dl_handles[j]->supplies;
					while (temp->name != NULL)
					{
						if (!strcmp(temp->name,"config_opt"))
						{
							config_opt = temp->function;
						}
						temp++;
					}
					if (config_opt != NULL)
					{
						(*config_opt)(option,value);
					}
				}
			}
		}
		free(argcopy);
	}
	for (i=0; i<num_dl_handles; i++)
	{
		if ((*dl_handles[i]->start)() != 0)
		{
			fprintf(stderr,"%s failed to start.\n",
				dl_handles[i]->name);
			exit(1);
		}
	}
	return(0);
}

int config_stop(void)
{
	return(-1);
}
